<?php $__env->startSection('content'); ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark">Checkout</h1>
                    </div><!-- /.col -->
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                            <li class="breadcrumb-item active">Licenses</li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <?php echo $__env->make('notify.errors', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo $__env->make('notify.success', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="container-fluid">
                <div class="row">
                    <!-- left column -->
                    <div class="col-md-6">
                        <!-- general form elements -->
                        <div class="card card-primary">
                            <div class="card-header">
                                <h3 class="card-title">Order License</h3>
                            </div>
                            </div>
                            <h3 class="card-title">With this option, you can offer your clients 7 days of free trial of any license to your clients. completely free. Trial can only be applied once per IP address for each license type.</h3>
                            <!-- /.card-header -->
                            <!-- form start -->
                            <form role="form" method="post" action="<?php echo e(route('license.trial')); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="card-body">
                                    <!-- Software select -->
                                    <div class="form-group">
                                        <label>Select Software:</label>
                                        <select onchange="makeLicenseKey(this)" class="form-control" name="software_id">
                                            <?php if($softwares): ?>
                                                <?php $__currentLoopData = $softwares; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $software): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option key-name="<?php echo e($software->name); ?>" value="<?php echo e($software->id); ?>"
                                                        <?php echo e(old('status') == $software->id ? 'selected' : ''); ?>>
                                                        <?php echo e($software->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="name">Enter IPv4:</label>
                                        <input type="text" class="form-control" value="<?php echo e(old('ip')); ?>"
                                            name="ip" id="ip" placeholder="">
                                    </div>
                                    <!-- End at select -->
                                    <?php
                                        $reseller_id = App\Models\Reseller::firstWhere('user_id', Auth::id());
                                    ?>
                                    <div class="form-group" style="display:none">
                                        <label>Reseller</label>
                                        <select class="form-control" name="reseller">
                                            <option value="<?php echo e($reseller_id->id); ?>"
                                                <?php echo e($reseller_id->reseller_id == $reseller_id->id ? 'selected' : ''); ?>>
                                                <?php echo e($reseller_id->name); ?></option>
                                        </select>
                                    </div>
                                    <!-- select -->
                                </div>
                                <!-- /.card-body -->

                                <div class="card-footer">
                                    <button type="submit" class="btn btn-primary">Order</button>
                                </div>
                            </form>
                        </div>
                    </div>

                </div>

            </div>

            <!-- /.card -->
    </div><!-- /.container-fluid -->
    </section>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        const makeLicenseKey = key => {
            console.dir(key.attributes);
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/c4rf8lseller/public_html/application/resources/views/licenses/trial.blade.php ENDPATH**/ ?>