@extends('layouts.layout')

@section('content')

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark">Checkout</h1>
                    </div><!-- /.col -->
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                            <li class="breadcrumb-item active">Licenses</li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            @include('notify.errors')
            @include('notify.success')

            <div class="container-fluid">
                <div class="row">
                    <!-- left column -->
                    <div class="col-md-6">
                        <!-- general form elements -->
                        <div class="card card-primary">
                            <div class="card-header">
                                <h3 class="card-title">Order License</h3>
                            </div>
                            <!-- /.card-header -->
                            <!-- form start -->
                            <form role="form" method="post" action="{{ route('license.add') }}">
                                @csrf
                                <div class="card-body">
                                    <div class="form-group">
                                        <label>Select Software:</label>
                                        <select onchange="makeLicenseKey(this)" class="form-control" name="software_id"
                                            id="software-select">
                                            @if ($softwares)
                                                <option selected>Select Software</option>
                                                @foreach ($softwares as $software)
                                                    <option key-name="{{ $software->name }}" value="{{ $software->id }}">
                                                        {{ $software->name }}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>


                                    <!--<div class="form-group">-->
                                    <!--    <label for="name">License key</label>-->
                                    <!--    <input type="text" class="form-control" value="{{ old('license_key') }}"-->
                                    <!--        name="license_key" id="license_key" placeholder="">-->
                                    <!--</div>-->

                                    <div id="div-content" class="d-none">
                                        <!-- End at select -->
                                        <div class="form-group">
                                            <label>Buy for:</label>
                                            <select class="form-control" name="end_at" id="show_month">

                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="name">IPv4</label>
                                            <input type="text" class="form-control" value="{{ old('ip') }}"
                                                name="ip" id="ip" placeholder="">
                                        </div>
                                    </div>
                                    <!-- select -->

                                    <!-- Software select -->


                                    <!-- select -->
                                    @php
                                        $reseller_id = App\Models\Reseller::firstWhere('user_id', Auth::id());
                                    @endphp
                                    <div class="form-group" style="display:none">
                                        <label>Reseller</label>
                                        <select class="form-control" name="reseller">
                                            <option value="{{ $reseller_id->id }}"
                                                {{ $reseller_id->reseller_id == $reseller_id->id ? 'selected' : '' }}>
                                                {{ $reseller_id->name }}</option>
                                        </select>
                                    </div>
                                    <!-- select -->
                                </div>
                                <!-- /.card-body -->

                                <div class="card-footer text-right">
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </div>
                            </form>
                        </div>
                    </div>

                </div>

            </div>

            <!-- /.card -->
    </div><!-- /.container-fluid -->
    </section>

@endsection

@push('script')
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(function() {
            $('#software-select').change(function() {
                var softwareId = $(this).val();
                $.ajax({
                    url: "/panel/product/price/" + softwareId,
                    success: function(data) {
                        $('#show_month').html(data);
                    }
                });
            });
        });
    </script>

    <script>
        const makeLicenseKey = key => {
            console.dir(key.attributes);
            $('#div-content').removeClass('d-none');
        }
    </script>
@endpush
