<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>CPS</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" type="image/x-icon" href="{{ asset('dist/img/logo.webp') }}">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="{{ asset('plugins/fontawesome-free/css/all.min.css') }}">
    <!-- Ionicons -->
    <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
    <!-- Tempusdominus Bbootstrap 4 -->
    <link rel="stylesheet"
        href="{{ asset('plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css') }}">
    <!-- iCheck -->
    <link rel="stylesheet" href="{{ asset('plugins/icheck-bootstrap/icheck-bootstrap.min.css') }}">
    <!-- JQVMap -->
    <link rel="stylesheet" href="{{ asset('plugins/jqvmap/jqvmap.min.css') }}">
    <!-- Theme style -->
    <link rel="stylesheet" href="{{ asset('dist/css/adminlte.min.css') }}">
    <!-- overlayScrollbars -->
    <link rel="stylesheet" href="{{ asset('plugins/overlayScrollbars/css/OverlayScrollbars.min.css') }}">
    <!-- Select2 -->
    <link rel="stylesheet" href="{{ asset('css/select2.min.css') }}">
    <!-- Editor -->
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/tinymce/5.2.0/skins/content/default/content.min.css">

    <!-- Daterange picker -->
    <!-- DataTables -->
    <link rel="stylesheet" href="{{ asset('plugins/datatables-bs4/css/dataTables.bootstrap4.css') }}">

    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css">
    <link rel="stylesheet" href="{{ asset('css/dataTables.checkboxes.css') }}">

    <!-- summernote -->
    <link rel="stylesheet" href="{{ asset('plugins/summernote/summernote-bs4.css') }}">
    <!-- Google Font: Source Sans Pro -->
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
    <style>
        @media (max-width: 991.98px) {
            .table {
                display: block;
                overflow-x: auto;
                white-space: nowrap;
            }
        }

        body {
            margin: 0;
            font-family: "Source Sans Pro", -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol";
            font-size: 1rem;
            font-weight: 400;
            line-height: 1.5;
            color: #212529;
            text-align: left;
            background-color: #fff;
        }

        .cartts {
            background-color: #007bff;
            color: #fff;
        }
        
    </style>
    <script type="text/javascript" id="f0bf078cb95ab8d8dc81e7706e50badb" src="//chat.magicbyte.pw/script.php?id=f0bf078cb95ab8d8dc81e7706e50badb" defer></script>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">

        <!-- Navbar -->
        <nav class="main-header navbar navbar-expand navbar-white navbar-light">
            <!-- Left navbar links -->
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i
                            class="fas fa-bars"></i></a>
                </li>
            </ul>

            <ul class="navbar-nav ml-auto">
                @if (session()->exists('user.idbeforeswitch.id') && session()->exists('user.idbeforeswitch.token'))
                <li class="nav-item d-none d-sm-inline-block">
                    <a class="nav-link text-danger" href="{{ route('users.go_back_to_admin', session('user.idbeforeswitch.token')) }}">
                        <i class="fas fa-arrow-left"></i> Go Back to Admin Panel
                    </a>
                </li>
                @endif
                @auth
                <li class="nav-item d-none d-sm-inline-block">
                    <span class="nav-link">Balance: ${{ App\Models\Reseller::firstWhere('user_id', Auth::id())->balance }}</span>
                </li>
                @endauth
            </ul>
              <li class="nav-item d-none d-sm-inline-block">
                  <a class="nav-link" href="{{ route('logout') }}">
                      <i class="fas fa-sign-out-alt"></i>
                  </a>
              </li>
        </nav>

        <!-- /.navbar -->

        <!-- Main Sidebar Container -->
        <aside class="main-sidebar sidebar-dark-primary elevation-4">
            <!-- Brand Logo -->
            <a href="{{ route('home') }}" class="brand-link">
                <img src="{{ asset('dist/img/logo.webp') }}" alt="Manage3 System Logo"
                    class="brand-image img-circle elevation-3" style="opacity: .8">
                <span class="brand-text font-weight-light">CPS System</span>
            </a>

            <!-- Sidebar -->
            <div class="sidebar">
                <!-- Sidebar user panel (optional) -->
                <div class="user-panel mt-3 pb-3 mb-3 d-flex">
                    <div class="image">
                        <img src="{{ asset('dist/img/user.png') }}" class="img-circle elevation-2" alt="User Image">
                    </div>
                    <div class="info">
                        <a href="{{ route('profile') }}" class="d-block">{{ \Auth::user()->username }}</a>
                    </div>
                </div>
                <!-- Sidebar Menu -->
                <nav class="mt-2">
                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                        data-accordion="false">
                        <!-- Add icons to the links using the .nav-icon class
               with font-awesome or any other icon font library -->
                        <li class="nav-item">
                            <a href="{{ route('home') }}" class="nav-link">
                                <i class="nav-icon fas fa-tachometer-alt"></i>
                                <p>
                                    Dashboard
                                </p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="#" class="nav-link">
                                <i class="nav-icon fas fa-database"></i>
                                <p>
                                    Manage License
                                    <i class="fas fa-angle-left right"></i>
                                </p>
                            </a>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="{{ route('licenses') }}" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>All License</p>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="{{ route('licenses') }}/add" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Order License</p>
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <li class="nav-item">
                            <a href="#" class="nav-link">
                                <i class="nav-icon fas fa-wallet"></i>
                                <p>
                                    Funds
                                    <i class="fas fa-angle-left right"></i>
                                </p>
                            </a>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="{{ route('uddoktapay.payment-form') }}" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Recharge</p>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="{{ route('redeem.index') }}" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Redeem</p>
                                    </a>
                                </li>
                                @if (Auth::user()->role == 'admin' || Auth::user()->role == 'master')
                                    <li class="nav-item">
                                        <a href="{{ route('redeem.store') }}" class="nav-link">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>Generate Redeem Code</p>
                                        </a>
                                    </li>
                                @endif
                            </ul>
                        </li>
                        @if (Auth::user()->role == 'admin')
                            <li class="nav-item">
                                <a href="{{ route('proxies') }}" class="nav-link">
                                    <i class="nav-icon fas fa-desktop"></i>
                                    <p>Configure Proxies</p>
                                </a>
                            </li>
                            <li class="nav-item">
                            <a href="{{ route('virtualserver') }}" class="nav-link">
                                <i class="nav-icon fas fa-book"></i>
                                <p>
                                    Virtual Servers
                                </p>
                            </a>
                        @endif
                        <li class="nav-item">
                                <a href="{{ route('invoices.index') }}" class="nav-link">
                                    <i class="nav-icon fas fa-file-invoice"></i>
                                    <p>Invoices</p>
                                </a>
                            </li>
                        @if (Auth::user()->role == 'admin' || Auth::user()->role == 'master')
                            <li class="nav-item">
                                <a href="#" class="nav-link">
                                    <i class="nav-icon fas fa-users"></i>
                                    <p>
                                        Manage Resellers
                                        <i class="fas fa-angle-left right"></i>
                                    </p>
                                </a>
                                <ul class="nav nav-treeview">

                                    <li class="nav-item">
                                        <a href="{{ route('resellers') }}" class="nav-link">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>Resellers</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('resellers') }}/add" class="nav-link">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>Add New Reseller</p>
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="{{ route('levels') }}" class="nav-link">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>Reseller Levels</p>
                                        </a>
                                    </li>

                                </ul>
                            </li>
                        @endif
                        <li class="nav-item">
                            <a href="{{ route('licenses') }}/trial" class="nav-link">
                                <i class="nav-icon fas fa-hourglass"></i>
                                <p>
                                    Free Trial
                                </p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('guide') }}" class="nav-link">
                                <i class="nav-icon fas fa-book"></i>
                                <p>
                                    WHMCS Integration
                                </p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('notices.index') }}" class="nav-link">
                                <i class="nav-icon fas fa-bell"></i>
                                <p>
                                    Notices
                                </p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="#" class="nav-link">
                                <i class="nav-icon fas fa-user"></i>
                                <p>
                                    Account
                                    <i class="fas fa-angle-left right"></i>
                                </p>
                            </a>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="{{ route('branding') }}" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Branding</p>
                                    </a>
                                </li>
                            </ul>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="{{ route('profile') }}" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Change Password</p>
                                    </a>
                                </li>
                            </ul>
                        </li>

                        @if (Auth::user()->role == 'admin')

                        <li class="nav-item">
                            <a href="{{ route('users.index') }}" class="nav-link">
                                <i class="nav-icon fas fa-users"></i>
                                <p>
                                    Users
                                </p>
                            </a>
                        </li>

                        <li class="nav-item">
                            <a href="#" class="nav-link">
                                <i class="nav-icon fas fa-th"></i>
                                <p>
                                    Admin Area
                                    <i class="fas fa-angle-left right"></i>
                                </p>
                            </a>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="{{ route('setting.view') }}" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Panel Settings</p>
                                    </a>
                                </li>
                            </ul>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="{{ route('softwares') }}" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>List Products</p>
                                    </a>
                                </li>
                            </ul>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="{{ route('cpanelversions.index') }}" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>cPanel Versions</p>
                                    </a>
                                </li>
                            </ul>
                             <ul class="nav nav-treeview">
                                        <li class="nav-item">
                                            <a href="{{ route('cpanelversions.show-update-form') }}" class="nav-link">
                                                <i class="far fa-circle nav-icon"></i>
                                                <p>cPanel Update Version</p>
                                            </a>
                                        </li>
                                    </ul>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="{{ route('message.index') }}" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Api Message</p>
                                    </a>
                                </li>
                            </ul>
                        </li>
                        @endif

                        <li class="nav-item">
                            <a href="{{ route('logout') }}" class="nav-link">
                                <i class="nav-icon fas fa-sign-out-alt"></i>
                                <p>
                                    Logout
                                </p>
                            </a>
                        </li>
                </nav>
                <!-- /.sidebar-menu -->
            </div>
            <!-- /.sidebar -->
        </aside>

        @yield('content')


        <!-- /.content-wrapper -->
        <footer class="main-footer">
            <strong>Copyright &copy; {{ date('Y') }} domain.com . </strong>
            All rights reserved.

        </footer>


        <!-- jQuery -->
        <script src="{{ asset('plugins/jquery/jquery.min.js') }}"></script>
        <!-- jQuery UI 1.11.4 -->
        <script src="{{ asset('plugins/jquery-ui/jquery-ui.min.js') }}"></script>
        <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
        <script>
            $.widget.bridge('uibutton', $.ui.button)
        </script>
        <!-- Bootstrap 4 -->
        <script src="{{ asset('plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
        <!-- Select2 -->


        <!-- ChartJS -->
        <script src="{{ asset('plugins/chart.js/Chart.min.js') }}"></script>
        <!-- Sparkline -->
        <script src="{{ asset('plugins/sparklines/sparkline.js') }}"></script>
        <!-- JQVMap -->
        <script src="{{ asset('plugins/jqvmap/jquery.vmap.min.js') }}"></script>
        <script src="{{ asset('plugins/jqvmap/maps/jquery.vmap.usa.js') }}"></script>
        <!-- jQuery Knob Chart -->
        <script src="{{ asset('plugins/jquery-knob/jquery.knob.min.js') }}"></script>
        <!-- daterangepicker -->
        <script src="{{ asset('plugins/moment/moment.min.js') }}"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js"></script>
        <!-- Tempusdominus Bootstrap 4 -->
        <script src="{{ asset('plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js') }}"></script>
        <!-- Summernote -->
        <script src="{{ asset('plugins/summernote/summernote-bs4.min.js') }}"></script>
        <!-- overlayScrollbars -->
        <script src="{{ asset('plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js') }}"></script>
        <!-- Editor -->
        <script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/5.2.0/tinymce.min.js"></script>

        <!-- AdminLTE App -->
        <script src="{{ asset('dist/js/adminlte.js') }}"></script>
        <!-- AdminLTE dashboard demo (This is only for demo purposes) -->
        <script src="{{ asset('plugins/datatables/jquery.dataTables.js') }}"></script>
        <script src="{{ asset('plugins/datatables-bs4/js/dataTables.bootstrap4.js') }}"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap-input-spinner@1.13.3/src/bootstrap-input-spinner.min.js"></script>
        <script src="{{ asset('js/dataTables.checkboxes.min.js') }}"></script>
        <script src="{{ asset('js/dataTables.buttons.min.js') }}"></script>
        <script src="{{ asset('js/select2.full.min.js') }}"></script>
        @stack('script')

        <!-- AdminLTE for demo purposes -->
        <script src="{{ asset('dist/js/demo.js') }}"></script>

        @yield('endfooter')
</body>

</html>
