@extends('layouts.layout')

@section('content')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark">All Invoices</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                            <li class="breadcrumb-item active">Invoices</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Invoice List</h3>
                            </div>
                            <div class="card-body">

                                @if ($invoices->isEmpty())
                                    <p>No invoices available.</p>
                                @else
                                    <table class="table mt-3">
                                        <thead>
                                            <tr>
                                                <th scope="col">Invoice ID</th>
                                                <th scope="col">Paid Date</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($invoices as $invoice)
                                                <tr>
                                                    <td>
                                                        <a href="{{ route('invoices.show', $invoice->id) }}">
                                                            Invoice #{{ $invoice->id }}
                                                        </a>
                                                    </td>
                                                    <td>
                                                        {{
                                                            $invoice->paid_at ? Carbon\Carbon::parse($invoice->paid_at)->format('F j, Y') : 'N/A' }}
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>

                                    {{ $invoices->links() }} {{-- Pagination links --}}
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
