<?php

namespace App\Notifications;

use app\License;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class ReNewLicenseNotification extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */

    private $license;
    public function __construct(License $license)
    {
        $this->license = $license;   //
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        $software_name = \App\Software::find($this->license->software_id)->name;
        $ip = $this->license->ip;
        return (new MailMessage)
            ->subject('License Renewed Successfully')
            ->greeting("Hello {$notifiable->username}")
            ->line('Congratulations, License Renewed Successfully.')
            ->line('IP: ' . $ip)
            ->line('Software: ' . $software_name)
            ->line('Expiry: ' . date('jS F Y', strtotime($this->license->end_at)))
            ->action('Renewed License', route('license.edit', $this->license->id))
            ->line("Thank you for using our license!")
            ->salutation("Best regards,\n\nSCP");
    }
}
