<?php

namespace App\Notifications;

use app\License;
use app\Invoice;
use App\Models\Reseller;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class NewLicenseNotification extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */

    private $license;
    public function __construct(License $license)
    {
        $this->license = $license;   //
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        $reseller = Reseller::firstWhere('id', $this->license->reseller_id);
        $software_name = \App\Software::find($this->license->software_id)->name;
        $level = \App\LevelReseller::find($reseller->level_id);
        $software = \App\Software::findorfail($this->license->software_id);
        $level_software = \App\LevelResellerOption::where('software_id', $software->id)->where('level_reseller_id', $level->id)->first();
        $product_cost = $level_software->price_reseller;
        $current_balance = $reseller->balance;
        $ip = $this->license->ip;
            // Create an invoice
        $invoice = new Invoice([
            'reseller_id' => $reseller->id,
            'amount' => $product_cost,
            'description' => 'New license purchased for ' . $software->name,
            'status' => 'unpaid',
            'ip' => $ip,
        ]);
        $invoice->save();


        // Associate the invoice with the license
        $this->license->invoice()->save($invoice);

        return (new MailMessage)
            ->subject('New License Registered')
            ->greeting("A new license has been registered")
            ->line('License IP: ' . $ip)
            ->line('Product name: '  . $software->name)
            ->line('Product cost: '  . $product_cost . '$')
            ->line('Expiry Date: ' . date('jS F Y', strtotime($this->license->end_at)))
            ->line('Invoice ID: ' . $invoice->id)
            ->line('Date of purchase: ' . $invoice->created_at)
            ->action('Check License', route('license.edit', $this->license->id))
            ->line("Thank you for using our license!")
            ->salutation("Best regards,\n\nSCP");
    }
}
