<?php

namespace App\Notifications;

use app\License;
use Carbon\Carbon;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class LicenseRenewalReminder extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    private $license;
    public function __construct(License $license)
    {
        $this->license = $license;   //
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        $software_name = \App\Software::find($this->license->software_id)->name;
        $ip = $this->license->ip;

        $expiry_date = Carbon::parse($this->license->end_at);
        $days_left = $expiry_date->diffInDays(now());

        if ($days_left > 0) {
            $message = (new MailMessage)
                ->subject('License Renewal Notice')
                ->greeting("Hello {$notifiable->username}")
                ->line('The following licenses are expiring soon:')
                ->line('IP: ' . $ip)
                ->line('Software: ' . $software_name)
                ->line('Expiry: ' . date('jS F Y', strtotime($this->license->end_at)))
                ->action('Renew License', route('license.renew', $this->license->id))
                ->line("Thank you for using our license!")
                ->salutation("Best regards,\n\nSCP");
        } else {
            $message = (new MailMessage)
                ->subject('License Renewal Notice')
                ->greeting("Hello {$notifiable->username}")
                ->line('The following licenses have expired:')
                ->line('IP: ' . $ip)
                ->line('Software: ' . $software_name)
                ->line('Expiry: ' . date('jS F Y', strtotime($this->license->end_at)))
                ->action('Renew License', route('license.renew', $this->license->id))
                ->line("Thank you for using our license!")
                ->salutation("Best regards,\n\nSCP");
        }
        return $message;
    }
}
