<?php

namespace App\Listeners;

use Illuminate\Auth\Events\Login;
use App\Notifications\LoginNotification;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendLoginNotification
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  Login  $event
     * @return void
     */
    public function handle(Login $event)
    {
        $request = request();
        $ip = $request->ip();
        $time = now();
        $device = $request->header('User-Agent');

        $user = $event->user;
        $user->notify(new LoginNotification(['ip' => $ip, 'time' => $time, 'device' => $device]));
    }
}
