<?php

namespace App\Http\Middleware;

use Closure;
use App\Models\License;
use Illuminate\Http\Request;

class LicenseOwnershipCheck
{
    public function handle($request, Closure $next)
    {
        $licenseId = $request->route('id'); // Assuming your route parameter is 'id'
        $license = License::find($licenseId);

        if (!$license) {
            abort(404, 'License not found');
        }

        // Check if the user is authenticated
        if (auth()->check()) {
            $user = auth()->user();

            // Check if the user is an admin
            if ($user->role === 'admin') {
                return $next($request); // Allow admin users to access any licenses
            }

            // Check if the user's ID matches the 'reseller_id' in the license record
            if ($license->reseller_id !== $user->id) {
                abort(403, 'Unauthorized'); // Return a 403 Forbidden response if the reseller doesn't own the license
            }
        } else {
            abort(403, 'Unauthorized'); // Return a 403 Forbidden response if the user is not authenticated
        }

        return $next($request);
    }
}
