<?php

namespace App\Http\Controllers;

use Exception;
use App\Models\Order;
use App\Models\Reseller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Stripe;

class StripePaymentController extends Controller
{

    /**
     * Show the payment view
     *
     * @return void
     */
    public function show(Request $request)
    {
        return view('stripe.payment-form', $request);
    }

    public function store(Request $request){
        Order::create([
            'full_name' => $request->full_name,
            'email'     => $request->email,
            'amount'    => $request->amount,
            'status'    => "Pending",
            'transaction_id'    => $request->transaction_id,
            'receipt_url'    => "",
            'payment_method'    => "COINBASE",
        ]);
    }

    public function check_payment_method(Request $request){
        if($request->payment_method == 1){
            return redirect()->route('stripe.pay')->with(['full_name'=> $request->full_name, 'email'=> $request->email, 'amount'=> $request->amount]);
        }elseif ($request->payment_method == 2){
            app(UddoktapayController::class)->pay($request);
        }else{
            flash()->addError('Error Form field required');
            return back();
        }
    }
    /**
     * Initializes the payment
     *
     * @param Request $request
     * @return void
     */
    public function pay(Request $request)
    {
        $validatedData = $request->validate([
            'full_name' => ['required', 'string'],
            'email'     => ['required', 'email'],
            'amount'    => ['required', 'integer'],
        ]);

        try {
            Stripe\Stripe::setApiKey(env('STRIPE_SECRET'));

            $charge = Stripe\Charge::create ([
                "amount" => 100 * $request->amount,
                "currency" => "usd",
                "source" => $request->stripeToken,
                "description" => "Deposit of $". $request->amount . " to your account.",
                "receipt_email" => $request->email
            ]);
        } catch(\Stripe\Exception\CardException $e) {
            flash()->addError($e->getError()->message);
            return redirect()->route('uddoktapay.payment-form');
        } catch (\Stripe\Exception\RateLimitException $e) {
            flash()->addError($e->getError()->message);
            return redirect()->route('uddoktapay.payment-form');
        } catch (\Stripe\Exception\InvalidRequestException $e) {
            flash()->addError($e->getError()->message);
            return redirect()->route('uddoktapay.payment-form');
        } catch (\Stripe\Exception\AuthenticationException $e) {
            flash()->addError($e->getError()->message);
            return redirect()->route('uddoktapay.payment-form');
        } catch (\Stripe\Exception\ApiConnectionException $e) {
            flash()->addError($e->getError()->message);
            return redirect()->route('uddoktapay.payment-form');
        } catch (\Stripe\Exception\ApiErrorException $e) {
            flash()->addError($e->getError()->message);
            return redirect()->route('uddoktapay.payment-form');
        } catch (Exception $e) {
            flash()->addError($e->getError()->message);
            return redirect()->route('uddoktapay.payment-form');
        }


        if($charge->paid  == true && $charge->status == "succeeded"){
            Order::create([
                'full_name' => $validatedData['full_name'],
                'email'     => $validatedData['email'],
                'amount'    => $validatedData['amount'],
                'status'    => $charge->status,
                'transaction_id'    => $charge->id,
                'receipt_url'    => $charge->receipt_url,
                'payment_method'    => "CARD",
            ]);

            return redirect()->route('stripe.success');
        }else{
            Order::create([
                'full_name' => $validatedData['full_name'],
                'email'     => $validatedData['email'],
                'amount'    => $validatedData['amount'],
                'status'    => $charge->status,
                'transaction_id'    => $charge->id,
                'payment_method'    => "CARD",
            ]);
            return redirect()->route('stripe.cancel');
        }

    }

    /**
     * Success URL
     *
     * @return void
     */
    public function success(Request $request)
    {
        $order = Order::firstWhere('email', Auth::user()->email)->latest()->first();
        $reseller = Reseller::firstWhere('user_id', Auth::user()->id);
        $reseller->balance += $order->amount;
        $reseller->save();


        $order->status = ($order->status == 'succeeded') ? 'Completed' : 'Pending';
        $order->save();

        flash()->addSuccess($order->amount . '$' . ' Added Sucessfully');
        return redirect()->route('uddoktapay.payment-form');
    }

    /**
     * Cancel URL
     *
     * @return void
     */
    public function cancel()
    {
        flash()->addError('Payment is cancelled');
        return redirect()->route('uddoktapay.payment-form');
    }
}
