<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Reseller;
use Srmklive\PayPal\Services\ExpressCheckout;
use App\Models\Order; // Assuming you have an Order model

class PayPalController extends Controller
{
    public function payment(Request $request)
    {
        $validatedData = $request->validate([
            'full_name' => ['required', 'string'],
            'email' => ['required', 'email'],
            'amount' => ['required', 'numeric'],
        ]);

        // Multiply the amount by 115 here
        $convertedAmount = $validatedData['amount'];

        $order = Order::create([
            'full_name' => $validatedData['full_name'],
            'email' => $validatedData['email'],
            'amount' => $convertedAmount,
        ]);

        $data = [];

        $data['items'] = [
            [
                'name' => 'Your Product',
                'price' => $convertedAmount, // Use the converted amount
                'desc' => 'Description for your product',
                'qty' => 1,
            ],
        ];

        $data['invoice_id'] = $order->id; // Use the order ID as the invoice ID
        $data['invoice_description'] = "Order #{$order->id} Invoice";
        $data['return_url'] = route('payment.success');
        $data['cancel_url'] = route('payment.cancel');
        $data['total'] = $convertedAmount; // Use the converted amount

        $provider = new ExpressCheckout;
        $response = $provider->setExpressCheckout($data);

        // Redirect to the PayPal link
        return redirect($response['paypal_link']);
    }

    public function cancel()
    {
        dd('Your payment is canceled. You can create a cancel page here.');
    }

    public function success(Request $request)
    {
        $provider = new ExpressCheckout;

        $response = $provider->getExpressCheckoutDetails($request->token);

        if (in_array(strtoupper($response['ACK']), ['SUCCESS', 'SUCCESSWITHWARNING'])) {
            dd('Your payment was successful. You can create a success page here.');
        } else {
            dd('Something is wrong.');
        }
    }
}
