<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Notice; // Import the Notice model

class NoticeController extends Controller
{
    public function index()
    {
        $notices = Notice::orderBy('created_at', 'desc')->paginate(20); // Paginate the results
    
        return view('notices.index', compact('notices'));
    }
    
    public function create()
    {
        return view('notices.create');
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'title' => 'required',
            'content' => 'required',
        ]);

        Notice::create([
            'title' => $request->title,
            'content' => $request->content,
        ]);

        return redirect()->route('notices.index')->with('success', 'Notice created successfully');
    }

    public function show($id)
    {
        $notice = Notice::find($id);
    
        if (!$notice) {
            return redirect()->route('notices.index')->with('error', 'Notice not found.');
        }
    
        return view('notices.show', compact('notice'));
    }
    

    public function edit($id)
    {
        $notice = Notice::find($id);
        return view('notices.edit', compact('notice'));
    }

    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'title' => 'required',
            'content' => 'required',
        ]);

        $notice = Notice::find($id);
        $notice->update([
            'title' => $request->title,
            'content' => $request->content,
        ]);

        return redirect()->route('notices.index')->with('success', 'Notice updated successfully');
    }

    public function destroy($id)
    {
        $notice = Notice::find($id);
        if (!$notice) {
            return redirect()->route('notices.index')->with('error', 'Notice not found.');
        }
    
        $notice->delete();
    
        return redirect()->route('notices.index')->with('success', 'Notice deleted successfully');
    }
    
}

