<?php

namespace App\Http\Controllers;
use App\Invoice;
use App\License;
use App\Models\Reseller;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use Illuminate\Http\Request;

class InvoiceController extends Controller
{
    public function index()
    {
        // Check if the logged in user is an admin
        if (Auth::user()->role === 'admin') {
            $invoices = Invoice::orderBy('created_at', 'desc')->simplePaginate(10);
        } else {
            // Get the currently logged in reseller
            $resellerId = Auth::id();
    
            // Retrieve only the invoices created by the logged in reseller
            $invoices = Invoice::where('reseller_id', $resellerId)
                ->orderBy('created_at', 'desc')
                ->simplePaginate(10);
        }
    
        return view('invoices.index', compact('invoices'));
    }
    
    public function show($id)
    {
        // Check if the logged in user is an admin
        if (Auth::user()->role === 'admin') {
            $invoice = Invoice::findOrFail($id);
        } else {
            // Get the currently logged in reseller
            $resellerId = Auth::id();
    
            // Retrieve the invoice only if it belongs to the logged in reseller
            $invoice = Invoice::where('reseller_id', $resellerId)
                ->findOrFail($id);
        }
    
        return view('invoices.show', compact('invoice'));
    }
    public function createInvoice($resellerId, $amount, $description, $status, $ip, $paidAt = null)
    {
        $invoice = new Invoice([
            'reseller_id' => $resellerId,
            'amount' => $amount,
            'description' => $description,
            'status' => $status,
            'ip' => $ip,
            'paid_at' => $paidAt,
        ]);
    
        if ($paidAt !== null) {
            $license = License::where('reseller_id', $resellerId)->orderBy('created_at', 'desc')->first();
            
            // Assuming the license has an end_at attribute
            if ($license) {
                $invoice->end_at = $license->end_at;
            }
        }
    
       // $invoice->save();
    
        return $invoice;
    }
    
    
    
    
    
}
