<?php


namespace app\console;

class Kernel extends \Illuminate\Foundation\Console\Kernel
{
    protected $commands = [
        \App\Console\Commands\UpdateServer::class,
        \App\Console\Commands\SendRenewalEmailsCommand::class,
    ];

    protected function schedule(\Illuminate\Console\Scheduling\Schedule $schedule)
    {
        $schedule->command('update:server')->everyMinute();
        $schedule->command('emails:send-renewal')->daily();
    }

    protected function commands()
    {
        $this->load(__DIR__ . '/Commands');
        require base_path('routes/console.php');
    }
}
