<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Hash;
use App\Models\User;

class RegistrationTest extends Command
{
    protected $signature = 'test:registration';

    protected $description = 'Test user registration process';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        $username = 'testuser';
        $email = 'testuser@example.com';
        $password = '123456';

        $data = [
            'username' => $username,
            'email' => $email,
            'password' => Hash::make($password),
        ];

        try {
            User::create($data);
            $this->info('User registered successfully.');
        } catch (\Exception $e) {
            $this->error('Error registering user: ' . $e->getMessage());
        }
    }
}
