<?php
namespace App\Casts;

use Illuminate\Contracts\Database\Eloquent\CastsAttributes;

class TypeCast implements CastsAttributes
{
    public function get($model, $key, $value, $attributes)
    {
        $types = ["user", "admin", "manager"];
        return $types[$value] ?? null;
    }

    public function set($model, $key, $value, $attributes)
    {
        $types = array_flip(["user", "admin", "manager"]);
        return $types[$value] ?? null;
    }
}
